<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;

class ContractInterruption extends Model 
{

    protected $table = 'contract_interruptions';
    public $timestamps = true;
    protected $fillable = array('contract_id', 'reason', 'begin_interruption_date', 'end_interruption_date');
    protected $visible = array('contract_id', 'reason', 'begin_interruption_date', 'end_interruption_date');

    public function contract()
    {
        return $this->belongsTo('EmployeeContract', 'contract_id', 'id');
    }

}